function MAPSMALL = rasterupscale10( MAP, slipsurfacevalue )
% Downsamples a raster representing a fault zone by a factor 10. It makes
% sure that the thin slip surfaces are not lost, by always including pixels
% with the slip surface value. For other pixels the mode is used.
% 
% Yannick Kremer 2011

height = floor( size(MAP,1) * .1 );
width =  floor( size(MAP,2) * .1 );

MAPSMALL = nan( height, width );

for x = 1 : width-1,
    for y = 1: height-1,
        
        block = double( MAP( ( y*10 - 5 ) : ( 4 + y*10 ),  (x*10 - 5) : (4 + x*10) ) );
        
        if any( block(:) == slipsurfacevalue ),
            upscaled = slipsurfacevalue;
        else
            upscaled = mode( block(:) );
        end
           
        MAPSMALL( y, x ) = upscaled;
    end
end

